package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableOrganizationAdminAccountRequest(
    adminAccountId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest = {
    import EnableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(NonEmptyString.unwrap(adminAccountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.securityhub.model.EnableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.EnableOrganizationAdminAccountRequest =
      zio.aws.securityhub.model
        .EnableOrganizationAdminAccountRequest(adminAccountId)
    def adminAccountId: NonEmptyString
    def getAdminAccountId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(adminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest
  ) extends zio.aws.securityhub.model.EnableOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.adminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest
  ): zio.aws.securityhub.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
