package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeActionTargetsRequest(
    actionTargetArns: Option[Iterable[NonEmptyString]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest = {
    import DescribeActionTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest
      .builder()
      .optionallyWith(
        actionTargetArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.actionTargetArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DescribeActionTargetsRequest.ReadOnly =
    zio.aws.securityhub.model.DescribeActionTargetsRequest.wrap(buildAwsValue())
}
object DescribeActionTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeActionTargetsRequest =
      zio.aws.securityhub.model.DescribeActionTargetsRequest(
        actionTargetArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def actionTargetArns: Option[List[NonEmptyString]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getActionTargetArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("actionTargetArns", actionTargetArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest
  ) extends zio.aws.securityhub.model.DescribeActionTargetsRequest.ReadOnly {
    override val actionTargetArns: Option[List[NonEmptyString]] = scala
      .Option(impl.actionTargetArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest
  ): zio.aws.securityhub.model.DescribeActionTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
