package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomDataIdentifiersResult(
    detections: Option[
      Iterable[zio.aws.securityhub.model.CustomDataIdentifiersDetections]
    ] = None,
    totalCount: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult = {
    import CustomDataIdentifiersResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
      .builder()
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly =
    zio.aws.securityhub.model.CustomDataIdentifiersResult.wrap(buildAwsValue())
}
object CustomDataIdentifiersResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CustomDataIdentifiersResult =
      zio.aws.securityhub.model.CustomDataIdentifiersResult(
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def detections: Option[
      List[zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly]
    ]
    def totalCount: Option[Long]
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
  ) extends zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly {
    override val detections: Option[
      List[zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly]
    ] = scala
      .Option(impl.detections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.CustomDataIdentifiersDetections.wrap(item)
        }.toList
      )
    override val totalCount: Option[Long] =
      scala.Option(impl.totalCount()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult
  ): zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly =
    new Wrapper(impl)
}
