package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait ControlStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.ControlStatus
}
object ControlStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.ControlStatus
  ): zio.aws.securityhub.model.ControlStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.ControlStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.ControlStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.securityhub.model.ControlStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ControlStatus =
      software.amazon.awssdk.services.securityhub.model.ControlStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.securityhub.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ControlStatus =
      software.amazon.awssdk.services.securityhub.model.ControlStatus.ENABLED
  }
  case object DISABLED extends zio.aws.securityhub.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ControlStatus =
      software.amazon.awssdk.services.securityhub.model.ControlStatus.DISABLED
  }
}
