package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsXrayEncryptionConfigDetails(
    keyId: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails = {
    import AwsXrayEncryptionConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
      .builder()
      .optionallyWith(
        keyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails
      .wrap(buildAwsValue())
}
object AwsXrayEncryptionConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails =
      zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails(
        keyId.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def keyId: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
  ) extends zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly {
    override val keyId: Option[NonEmptyString] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsXrayEncryptionConfigDetails
  ): zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly =
    new Wrapper(impl)
}
