package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsWafWebAclRule(
    action: Option[zio.aws.securityhub.model.WafAction] = None,
    excludedRules: Option[Iterable[zio.aws.securityhub.model.WafExcludedRule]] =
      None,
    overrideAction: Option[zio.aws.securityhub.model.WafOverrideAction] = None,
    priority: Option[Integer] = None,
    ruleId: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule = {
    import AwsWafWebAclRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .optionallyWith(overrideAction.map(value => value.buildAwsValue()))(
        _.overrideAction
      )
      .optionallyWith(
        priority.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.priority)
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly =
    zio.aws.securityhub.model.AwsWafWebAclRule.wrap(buildAwsValue())
}
object AwsWafWebAclRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafWebAclRule =
      zio.aws.securityhub.model.AwsWafWebAclRule(
        action.map(value => value.asEditable),
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        overrideAction.map(value => value.asEditable),
        priority.map(value => value),
        ruleId.map(value => value),
        `type`.map(value => value)
      )
    def action: Option[zio.aws.securityhub.model.WafAction.ReadOnly]
    def excludedRules
        : Option[List[zio.aws.securityhub.model.WafExcludedRule.ReadOnly]]
    def overrideAction
        : Option[zio.aws.securityhub.model.WafOverrideAction.ReadOnly]
    def priority: Option[Integer]
    def ruleId: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getAction
        : ZIO[Any, AwsError, zio.aws.securityhub.model.WafAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getExcludedRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.WafExcludedRule.ReadOnly
    ]] = AwsError.unwrapOptionField("excludedRules", excludedRules)
    def getOverrideAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.WafOverrideAction.ReadOnly
    ] = AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
  ) extends zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly {
    override val action: Option[zio.aws.securityhub.model.WafAction.ReadOnly] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.securityhub.model.WafAction.wrap(value))
    override val excludedRules
        : Option[List[zio.aws.securityhub.model.WafExcludedRule.ReadOnly]] =
      scala
        .Option(impl.excludedRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.WafExcludedRule.wrap(item)
          }.toList
        )
    override val overrideAction
        : Option[zio.aws.securityhub.model.WafOverrideAction.ReadOnly] = scala
      .Option(impl.overrideAction())
      .map(value => zio.aws.securityhub.model.WafOverrideAction.wrap(value))
    override val priority: Option[Integer] = scala
      .Option(impl.priority())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val ruleId: Option[NonEmptyString] = scala
      .Option(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
  ): zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly = new Wrapper(impl)
}
