package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsWafRateBasedRuleMatchPredicate(
    dataId: Option[NonEmptyString] = None,
    negated: Option[Boolean] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicate = {
    import AwsWafRateBasedRuleMatchPredicate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicate
      .builder()
      .optionallyWith(
        dataId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dataId)
      .optionallyWith(negated.map(value => value: java.lang.Boolean))(_.negated)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.ReadOnly =
    zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate
      .wrap(buildAwsValue())
}
object AwsWafRateBasedRuleMatchPredicate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate =
      zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate(
        dataId.map(value => value),
        negated.map(value => value),
        `type`.map(value => value)
      )
    def dataId: Option[NonEmptyString]
    def negated: Option[Boolean]
    def `type`: Option[NonEmptyString]
    def getDataId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dataId", dataId)
    def getNegated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negated", negated)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicate
  ) extends zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.ReadOnly {
    override val dataId: Option[NonEmptyString] = scala
      .Option(impl.dataId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val negated: Option[Boolean] =
      scala.Option(impl.negated()).map(value => value: Boolean)
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicate
  ): zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.ReadOnly =
    new Wrapper(impl)
}
