package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails(
    daysAfterInitiation: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
      .builder()
      .optionallyWith(
        daysAfterInitiation.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.daysAfterInitiation)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails(
          daysAfterInitiation.map(value => value)
        )
    def daysAfterInitiation: Option[Integer]
    def getDaysAfterInitiation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("daysAfterInitiation", daysAfterInitiation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly {
    override val daysAfterInitiation: Option[Integer] = scala
      .Option(impl.daysAfterInitiation())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly =
    new Wrapper(impl)
}
