package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallFirewallDetails(
    deleteProtection: Option[Boolean] = None,
    description: Option[NonEmptyString] = None,
    firewallArn: Option[NonEmptyString] = None,
    firewallId: Option[NonEmptyString] = None,
    firewallName: Option[NonEmptyString] = None,
    firewallPolicyArn: Option[NonEmptyString] = None,
    firewallPolicyChangeProtection: Option[Boolean] = None,
    subnetChangeProtection: Option[Boolean] = None,
    subnetMappings: Option[Iterable[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
    ]] = None,
    vpcId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails = {
    import AwsNetworkFirewallFirewallDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
      .builder()
      .optionallyWith(deleteProtection.map(value => value: java.lang.Boolean))(
        _.deleteProtection
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        firewallArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.firewallId)
      .optionallyWith(
        firewallName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallName)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        firewallPolicyChangeProtection.map(value => value: java.lang.Boolean)
      )(_.firewallPolicyChangeProtection)
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .optionallyWith(
        subnetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetMappings)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallFirewallDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails(
        deleteProtection.map(value => value),
        description.map(value => value),
        firewallArn.map(value => value),
        firewallId.map(value => value),
        firewallName.map(value => value),
        firewallPolicyArn.map(value => value),
        firewallPolicyChangeProtection.map(value => value),
        subnetChangeProtection.map(value => value),
        subnetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def deleteProtection: Option[Boolean]
    def description: Option[NonEmptyString]
    def firewallArn: Option[NonEmptyString]
    def firewallId: Option[NonEmptyString]
    def firewallName: Option[NonEmptyString]
    def firewallPolicyArn: Option[NonEmptyString]
    def firewallPolicyChangeProtection: Option[Boolean]
    def subnetChangeProtection: Option[Boolean]
    def subnetMappings: Option[List[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly
    ]]
    def vpcId: Option[NonEmptyString]
    def getDeleteProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteProtection", deleteProtection)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallId", firewallId)
    def getFirewallName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getFirewallPolicyChangeProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "firewallPolicyChangeProtection",
        firewallPolicyChangeProtection
      )
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
    def getSubnetMappings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetMappings", subnetMappings)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly {
    override val deleteProtection: Option[Boolean] =
      scala.Option(impl.deleteProtection()).map(value => value: Boolean)
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallArn: Option[NonEmptyString] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallId: Option[NonEmptyString] = scala
      .Option(impl.firewallId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallName: Option[NonEmptyString] = scala
      .Option(impl.firewallName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallPolicyArn: Option[NonEmptyString] = scala
      .Option(impl.firewallPolicyArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallPolicyChangeProtection: Option[Boolean] = scala
      .Option(impl.firewallPolicyChangeProtection())
      .map(value => value: Boolean)
    override val subnetChangeProtection: Option[Boolean] =
      scala.Option(impl.subnetChangeProtection()).map(value => value: Boolean)
    override val subnetMappings: Option[List[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly
    ]] = scala
      .Option(impl.subnetMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
            .wrap(item)
        }.toList
      )
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly =
    new Wrapper(impl)
}
