package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsKmsKeyDetails(
    awsAccountId: Option[NonEmptyString] = None,
    creationDate: Option[Double] = None,
    keyId: Option[NonEmptyString] = None,
    keyManager: Option[NonEmptyString] = None,
    keyState: Option[NonEmptyString] = None,
    origin: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    keyRotationStatus: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails = {
    import AwsKmsKeyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .optionallyWith(creationDate.map(value => value: java.lang.Double))(
        _.creationDate
      )
      .optionallyWith(
        keyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        keyManager.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyManager)
      .optionallyWith(
        keyState.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyState)
      .optionallyWith(
        origin.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.origin)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(keyRotationStatus.map(value => value: java.lang.Boolean))(
        _.keyRotationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsKmsKeyDetails.wrap(buildAwsValue())
}
object AwsKmsKeyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsKmsKeyDetails =
      zio.aws.securityhub.model.AwsKmsKeyDetails(
        awsAccountId.map(value => value),
        creationDate.map(value => value),
        keyId.map(value => value),
        keyManager.map(value => value),
        keyState.map(value => value),
        origin.map(value => value),
        description.map(value => value),
        keyRotationStatus.map(value => value)
      )
    def awsAccountId: Option[NonEmptyString]
    def creationDate: Option[Double]
    def keyId: Option[NonEmptyString]
    def keyManager: Option[NonEmptyString]
    def keyState: Option[NonEmptyString]
    def origin: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def keyRotationStatus: Option[Boolean]
    def getAwsAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getCreationDate: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getKeyManager: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyManager", keyManager)
    def getKeyState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getOrigin: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("origin", origin)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getKeyRotationStatus: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyRotationStatus", keyRotationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
  ) extends zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly {
    override val awsAccountId: Option[NonEmptyString] = scala
      .Option(impl.awsAccountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val creationDate: Option[Double] =
      scala.Option(impl.creationDate()).map(value => value: Double)
    override val keyId: Option[NonEmptyString] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyManager: Option[NonEmptyString] = scala
      .Option(impl.keyManager())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyState: Option[NonEmptyString] = scala
      .Option(impl.keyState())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val origin: Option[NonEmptyString] = scala
      .Option(impl.origin())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyRotationStatus: Option[Boolean] =
      scala.Option(impl.keyRotationStatus()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
  ): zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly = new Wrapper(impl)
}
