package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamPolicyVersion(
    versionId: Option[NonEmptyString] = None,
    isDefaultVersion: Option[Boolean] = None,
    createDate: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion = {
    import AwsIamPolicyVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion
      .builder()
      .optionallyWith(
        versionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(isDefaultVersion.map(value => value: java.lang.Boolean))(
        _.isDefaultVersion
      )
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly =
    zio.aws.securityhub.model.AwsIamPolicyVersion.wrap(buildAwsValue())
}
object AwsIamPolicyVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamPolicyVersion =
      zio.aws.securityhub.model.AwsIamPolicyVersion(
        versionId.map(value => value),
        isDefaultVersion.map(value => value),
        createDate.map(value => value)
      )
    def versionId: Option[NonEmptyString]
    def isDefaultVersion: Option[Boolean]
    def createDate: Option[NonEmptyString]
    def getVersionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion
  ) extends zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly {
    override val versionId: Option[NonEmptyString] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isDefaultVersion: Option[Boolean] =
      scala.Option(impl.isDefaultVersion()).map(value => value: Boolean)
    override val createDate: Option[NonEmptyString] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion
  ): zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly = new Wrapper(impl)
}
