package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbv2LoadBalancerAttribute(
    key: Option[NonEmptyString] = None,
    value: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute = {
    import AwsElbv2LoadBalancerAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute
      .builder()
      .optionallyWith(
        key.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.ReadOnly =
    zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute
      .wrap(buildAwsValue())
}
object AwsElbv2LoadBalancerAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute =
      zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Option[NonEmptyString]
    def value: Option[NonEmptyString]
    def getKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute
  ) extends zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.ReadOnly {
    override val key: Option[NonEmptyString] = scala
      .Option(impl.key())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute
  ): zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.ReadOnly =
    new Wrapper(impl)
}
