package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerBackendServerDescription(
    instancePort: Option[Integer] = None,
    policyNames: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription = {
    import AwsElbLoadBalancerBackendServerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription
      .builder()
      .optionallyWith(
        instancePort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instancePort)
      .optionallyWith(
        policyNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerBackendServerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription =
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription(
        instancePort.map(value => value),
        policyNames.map(value => value)
      )
    def instancePort: Option[Integer]
    def policyNames: Option[List[NonEmptyString]]
    def getInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instancePort", instancePort)
    def getPolicyNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("policyNames", policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly {
    override val instancePort: Option[Integer] = scala
      .Option(impl.instancePort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val policyNames: Option[List[NonEmptyString]] = scala
      .Option(impl.policyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerBackendServerDescription
  ): zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly =
    new Wrapper(impl)
}
