package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsDetails(
    command: Option[Iterable[NonEmptyString]] = None,
    cpu: Option[Integer] = None,
    dependsOn: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
    ]] = None,
    disableNetworking: Option[Boolean] = None,
    dnsSearchDomains: Option[Iterable[NonEmptyString]] = None,
    dnsServers: Option[Iterable[NonEmptyString]] = None,
    dockerLabels: Option[Map[NonEmptyString, NonEmptyString]] = None,
    dockerSecurityOptions: Option[Iterable[NonEmptyString]] = None,
    entryPoint: Option[Iterable[NonEmptyString]] = None,
    environment: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
    ]] = None,
    environmentFiles: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
    ]] = None,
    essential: Option[Boolean] = None,
    extraHosts: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
    ]] = None,
    firelensConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
    ] = None,
    healthCheck: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
    ] = None,
    hostname: Option[NonEmptyString] = None,
    image: Option[NonEmptyString] = None,
    interactive: Option[Boolean] = None,
    links: Option[Iterable[NonEmptyString]] = None,
    linuxParameters: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
    ] = None,
    logConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
    ] = None,
    memory: Option[Integer] = None,
    memoryReservation: Option[Integer] = None,
    mountPoints: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
    ]] = None,
    name: Option[NonEmptyString] = None,
    portMappings: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
    ]] = None,
    privileged: Option[Boolean] = None,
    pseudoTerminal: Option[Boolean] = None,
    readonlyRootFilesystem: Option[Boolean] = None,
    repositoryCredentials: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
    ] = None,
    resourceRequirements: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
    ]] = None,
    secrets: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
    ]] = None,
    startTimeout: Option[Integer] = None,
    stopTimeout: Option[Integer] = None,
    systemControls: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
    ]] = None,
    ulimits: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
    ]] = None,
    user: Option[NonEmptyString] = None,
    volumesFrom: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
    ]] = None,
    workingDirectory: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
      .builder()
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        cpu.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cpu)
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependsOn)
      .optionallyWith(disableNetworking.map(value => value: java.lang.Boolean))(
        _.disableNetworking
      )
      .optionallyWith(
        dnsSearchDomains.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsSearchDomains)
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(
        dockerLabels.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dockerLabels)
      .optionallyWith(
        dockerSecurityOptions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dockerSecurityOptions)
      .optionallyWith(
        entryPoint.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entryPoint)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        environmentFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentFiles)
      .optionallyWith(essential.map(value => value: java.lang.Boolean))(
        _.essential
      )
      .optionallyWith(
        extraHosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extraHosts)
      .optionallyWith(
        firelensConfiguration.map(value => value.buildAwsValue())
      )(_.firelensConfiguration)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(
        hostname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        image.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(interactive.map(value => value: java.lang.Boolean))(
        _.interactive
      )
      .optionallyWith(
        links.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.links)
      .optionallyWith(linuxParameters.map(value => value.buildAwsValue()))(
        _.linuxParameters
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        memory.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.memory)
      .optionallyWith(
        memoryReservation.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.memoryReservation)
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        portMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portMappings)
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(pseudoTerminal.map(value => value: java.lang.Boolean))(
        _.pseudoTerminal
      )
      .optionallyWith(
        readonlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readonlyRootFilesystem)
      .optionallyWith(
        repositoryCredentials.map(value => value.buildAwsValue())
      )(_.repositoryCredentials)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .optionallyWith(
        secrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secrets)
      .optionallyWith(
        startTimeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.startTimeout)
      .optionallyWith(
        stopTimeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.stopTimeout)
      .optionallyWith(
        systemControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.systemControls)
      .optionallyWith(
        ulimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ulimits)
      .optionallyWith(
        user.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        volumesFrom.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumesFrom)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails(
        command.map(value => value),
        cpu.map(value => value),
        dependsOn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableNetworking.map(value => value),
        dnsSearchDomains.map(value => value),
        dnsServers.map(value => value),
        dockerLabels.map(value => value),
        dockerSecurityOptions.map(value => value),
        entryPoint.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        essential.map(value => value),
        extraHosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firelensConfiguration.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        hostname.map(value => value),
        image.map(value => value),
        interactive.map(value => value),
        links.map(value => value),
        linuxParameters.map(value => value.asEditable),
        logConfiguration.map(value => value.asEditable),
        memory.map(value => value),
        memoryReservation.map(value => value),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        portMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privileged.map(value => value),
        pseudoTerminal.map(value => value),
        readonlyRootFilesystem.map(value => value),
        repositoryCredentials.map(value => value.asEditable),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTimeout.map(value => value),
        stopTimeout.map(value => value),
        systemControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ulimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        user.map(value => value),
        volumesFrom.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workingDirectory.map(value => value)
      )
    def command: Option[List[NonEmptyString]]
    def cpu: Option[Integer]
    def dependsOn: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly
    ]]
    def disableNetworking: Option[Boolean]
    def dnsSearchDomains: Option[List[NonEmptyString]]
    def dnsServers: Option[List[NonEmptyString]]
    def dockerLabels: Option[Map[NonEmptyString, NonEmptyString]]
    def dockerSecurityOptions: Option[List[NonEmptyString]]
    def entryPoint: Option[List[NonEmptyString]]
    def environment: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.ReadOnly
    ]]
    def environmentFiles: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.ReadOnly
    ]]
    def essential: Option[Boolean]
    def extraHosts: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly
    ]]
    def firelensConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly
    ]
    def healthCheck: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly
    ]
    def hostname: Option[NonEmptyString]
    def image: Option[NonEmptyString]
    def interactive: Option[Boolean]
    def links: Option[List[NonEmptyString]]
    def linuxParameters: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly
    ]
    def logConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly
    ]
    def memory: Option[Integer]
    def memoryReservation: Option[Integer]
    def mountPoints: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly
    ]]
    def name: Option[NonEmptyString]
    def portMappings: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly
    ]]
    def privileged: Option[Boolean]
    def pseudoTerminal: Option[Boolean]
    def readonlyRootFilesystem: Option[Boolean]
    def repositoryCredentials: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly
    ]
    def resourceRequirements: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly
    ]]
    def secrets: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.ReadOnly
    ]]
    def startTimeout: Option[Integer]
    def stopTimeout: Option[Integer]
    def systemControls: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.ReadOnly
    ]]
    def ulimits: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly
    ]]
    def user: Option[NonEmptyString]
    def volumesFrom: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly
    ]]
    def workingDirectory: Option[NonEmptyString]
    def getCommand: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("command", command)
    def getCpu: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getDependsOn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getDisableNetworking: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableNetworking", disableNetworking)
    def getDnsSearchDomains: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dnsSearchDomains", dnsSearchDomains)
    def getDnsServers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getDockerLabels
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("dockerLabels", dockerLabels)
    def getDockerSecurityOptions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dockerSecurityOptions", dockerSecurityOptions)
    def getEntryPoint: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getEnvironment: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getEnvironmentFiles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentFiles", environmentFiles)
    def getEssential: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("essential", essential)
    def getExtraHosts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("extraHosts", extraHosts)
    def getFirelensConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("firelensConfiguration", firelensConfiguration)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getHostname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("image", image)
    def getInteractive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interactive", interactive)
    def getLinks: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("links", links)
    def getLinuxParameters: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly
    ] = AwsError.unwrapOptionField("linuxParameters", linuxParameters)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getMemory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getMountPoints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPortMappings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("portMappings", portMappings)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getPseudoTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pseudoTerminal", pseudoTerminal)
    def getReadonlyRootFilesystem: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("readonlyRootFilesystem", readonlyRootFilesystem)
    def getRepositoryCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryCredentials", repositoryCredentials)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
    def getSecrets: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("secrets", secrets)
    def getStartTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startTimeout", startTimeout)
    def getStopTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stopTimeout", stopTimeout)
    def getSystemControls: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("systemControls", systemControls)
    def getUlimits: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ulimits", ulimits)
    def getUser: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("user", user)
    def getVolumesFrom: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("volumesFrom", volumesFrom)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly {
    override val command: Option[List[NonEmptyString]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val cpu: Option[Integer] = scala
      .Option(impl.cpu())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val dependsOn: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly
    ]] = scala
      .Option(impl.dependsOn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
            .wrap(item)
        }.toList
      )
    override val disableNetworking: Option[Boolean] =
      scala.Option(impl.disableNetworking()).map(value => value: Boolean)
    override val dnsSearchDomains: Option[List[NonEmptyString]] = scala
      .Option(impl.dnsSearchDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val dnsServers: Option[List[NonEmptyString]] = scala
      .Option(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val dockerLabels: Option[Map[NonEmptyString, NonEmptyString]] =
      scala
        .Option(impl.dockerLabels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val dockerSecurityOptions: Option[List[NonEmptyString]] = scala
      .Option(impl.dockerSecurityOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val entryPoint: Option[List[NonEmptyString]] = scala
      .Option(impl.entryPoint())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val environment: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.ReadOnly
    ]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
            .wrap(item)
        }.toList
      )
    override val environmentFiles: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.ReadOnly
    ]] = scala
      .Option(impl.environmentFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
            .wrap(item)
        }.toList
      )
    override val essential: Option[Boolean] =
      scala.Option(impl.essential()).map(value => value: Boolean)
    override val extraHosts: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly
    ]] = scala
      .Option(impl.extraHosts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
            .wrap(item)
        }.toList
      )
    override val firelensConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.firelensConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
          .wrap(value)
      )
    override val healthCheck: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly
    ] = scala
      .Option(impl.healthCheck())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
          .wrap(value)
      )
    override val hostname: Option[NonEmptyString] = scala
      .Option(impl.hostname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val image: Option[NonEmptyString] = scala
      .Option(impl.image())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val interactive: Option[Boolean] =
      scala.Option(impl.interactive()).map(value => value: Boolean)
    override val links: Option[List[NonEmptyString]] = scala
      .Option(impl.links())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val linuxParameters: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.ReadOnly
    ] = scala
      .Option(impl.linuxParameters())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
          .wrap(value)
      )
    override val logConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.logConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
          .wrap(value)
      )
    override val memory: Option[Integer] = scala
      .Option(impl.memory())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val memoryReservation: Option[Integer] = scala
      .Option(impl.memoryReservation())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val mountPoints: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly
    ]] = scala
      .Option(impl.mountPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
            .wrap(item)
        }.toList
      )
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val portMappings: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly
    ]] = scala
      .Option(impl.portMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
            .wrap(item)
        }.toList
      )
    override val privileged: Option[Boolean] =
      scala.Option(impl.privileged()).map(value => value: Boolean)
    override val pseudoTerminal: Option[Boolean] =
      scala.Option(impl.pseudoTerminal()).map(value => value: Boolean)
    override val readonlyRootFilesystem: Option[Boolean] =
      scala.Option(impl.readonlyRootFilesystem()).map(value => value: Boolean)
    override val repositoryCredentials: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly
    ] = scala
      .Option(impl.repositoryCredentials())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
          .wrap(value)
      )
    override val resourceRequirements: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly
    ]] = scala
      .Option(impl.resourceRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
            .wrap(item)
        }.toList
      )
    override val secrets: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.ReadOnly
    ]] = scala
      .Option(impl.secrets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
            .wrap(item)
        }.toList
      )
    override val startTimeout: Option[Integer] = scala
      .Option(impl.startTimeout())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val stopTimeout: Option[Integer] = scala
      .Option(impl.stopTimeout())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val systemControls: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.ReadOnly
    ]] = scala
      .Option(impl.systemControls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
            .wrap(item)
        }.toList
      )
    override val ulimits: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly
    ]] = scala
      .Option(impl.ulimits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
            .wrap(item)
        }.toList
      )
    override val user: Option[NonEmptyString] = scala
      .Option(impl.user())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumesFrom: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly
    ]] = scala
      .Option(impl.volumesFrom())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
            .wrap(item)
        }.toList
      )
    override val workingDirectory: Option[NonEmptyString] = scala
      .Option(impl.workingDirectory())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly =
    new Wrapper(impl)
}
