package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceLoadBalancersDetails(
    containerName: Option[NonEmptyString] = None,
    containerPort: Option[Integer] = None,
    loadBalancerName: Option[NonEmptyString] = None,
    targetGroupArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails = {
    import AwsEcsServiceLoadBalancersDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
      .builder()
      .optionallyWith(
        containerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .optionallyWith(
        containerPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.containerPort)
      .optionallyWith(
        loadBalancerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        targetGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.targetGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceLoadBalancersDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails =
      zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails(
        containerName.map(value => value),
        containerPort.map(value => value),
        loadBalancerName.map(value => value),
        targetGroupArn.map(value => value)
      )
    def containerName: Option[NonEmptyString]
    def containerPort: Option[Integer]
    def loadBalancerName: Option[NonEmptyString]
    def targetGroupArn: Option[NonEmptyString]
    def getContainerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getLoadBalancerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getTargetGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly {
    override val containerName: Option[NonEmptyString] = scala
      .Option(impl.containerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val containerPort: Option[Integer] = scala
      .Option(impl.containerPort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val loadBalancerName: Option[NonEmptyString] = scala
      .Option(impl.loadBalancerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val targetGroupArn: Option[NonEmptyString] = scala
      .Option(impl.targetGroupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails
  ): zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly =
    new Wrapper(impl)
}
