package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterConfigurationExecuteCommandConfigurationDetails(
    kmsKeyId: Option[NonEmptyString] = None,
    logConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
    ] = None,
    logging: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails = {
    import AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        logging.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.logging)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsClusterConfigurationExecuteCommandConfigurationDetails(
          kmsKeyId.map(value => value),
          logConfiguration.map(value => value.asEditable),
          logging.map(value => value)
        )
    def kmsKeyId: Option[NonEmptyString]
    def logConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly
    ]
    def logging: Option[NonEmptyString]
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getLogging: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("logging", logging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly {
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.logConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
          .wrap(value)
      )
    override val logging: Option[NonEmptyString] = scala
      .Option(impl.logging())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
