package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkInterfaceSecurityGroup(
    groupName: Option[NonEmptyString] = None,
    groupId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup = {
    import AwsEc2NetworkInterfaceSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
      .wrap(buildAwsValue())
}
object AwsEc2NetworkInterfaceSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup =
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup(
        groupName.map(value => value),
        groupId.map(value => value)
      )
    def groupName: Option[NonEmptyString]
    def groupId: Option[NonEmptyString]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
  ) extends zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly {
    override val groupName: Option[NonEmptyString] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupId: Option[NonEmptyString] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
  ): zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
