package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkAclDetails(
    isDefault: Option[Boolean] = None,
    networkAclId: Option[NonEmptyString] = None,
    ownerId: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    associations: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation]
    ] = None,
    entries: Option[Iterable[zio.aws.securityhub.model.AwsEc2NetworkAclEntry]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails = {
    import AwsEc2NetworkAclDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
      .builder()
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        networkAclId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkAclId)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkAclDetails.wrap(buildAwsValue())
}
object AwsEc2NetworkAclDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkAclDetails =
      zio.aws.securityhub.model.AwsEc2NetworkAclDetails(
        isDefault.map(value => value),
        networkAclId.map(value => value),
        ownerId.map(value => value),
        vpcId.map(value => value),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isDefault: Option[Boolean]
    def networkAclId: Option[NonEmptyString]
    def ownerId: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def associations: Option[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly]
    ]
    def entries
        : Option[List[zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly]]
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getNetworkAclId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkAclId", networkAclId)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
  ) extends zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly {
    override val isDefault: Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
    override val networkAclId: Option[NonEmptyString] = scala
      .Option(impl.networkAclId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerId: Option[NonEmptyString] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val associations: Option[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly]
    ] = scala
      .Option(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.wrap(item)
        }.toList
      )
    override val entries: Option[
      List[zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly]
    ] = scala
      .Option(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkAclEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclDetails
  ): zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly = new Wrapper(
    impl
  )
}
