package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectLogsConfigDetails(
    cloudWatchLogs: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
    ] = None,
    s3Logs: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails = {
    import AwsCodeBuildProjectLogsConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectLogsConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails(
        cloudWatchLogs.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable)
      )
    def cloudWatchLogs: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly
    ]
    def s3Logs: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly
    ]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Logs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly {
    override val cloudWatchLogs: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly
    ] = scala
      .Option(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
          .wrap(value)
      )
    override val s3Logs: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly
    ] = scala
      .Option(impl.s3Logs())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly =
    new Wrapper(impl)
}
