package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudTrailTrailDetails(
    cloudWatchLogsLogGroupArn: Option[NonEmptyString] = None,
    cloudWatchLogsRoleArn: Option[NonEmptyString] = None,
    hasCustomEventSelectors: Option[Boolean] = None,
    homeRegion: Option[NonEmptyString] = None,
    includeGlobalServiceEvents: Option[Boolean] = None,
    isMultiRegionTrail: Option[Boolean] = None,
    isOrganizationTrail: Option[Boolean] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    logFileValidationEnabled: Option[Boolean] = None,
    name: Option[NonEmptyString] = None,
    s3BucketName: Option[NonEmptyString] = None,
    s3KeyPrefix: Option[NonEmptyString] = None,
    snsTopicArn: Option[NonEmptyString] = None,
    snsTopicName: Option[NonEmptyString] = None,
    trailArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails = {
    import AwsCloudTrailTrailDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(
        cloudWatchLogsRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsRoleArn)
      .optionallyWith(
        hasCustomEventSelectors.map(value => value: java.lang.Boolean)
      )(_.hasCustomEventSelectors)
      .optionallyWith(
        homeRegion.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.homeRegion)
      .optionallyWith(
        includeGlobalServiceEvents.map(value => value: java.lang.Boolean)
      )(_.includeGlobalServiceEvents)
      .optionallyWith(
        isMultiRegionTrail.map(value => value: java.lang.Boolean)
      )(_.isMultiRegionTrail)
      .optionallyWith(
        isOrganizationTrail.map(value => value: java.lang.Boolean)
      )(_.isOrganizationTrail)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        logFileValidationEnabled.map(value => value: java.lang.Boolean)
      )(_.logFileValidationEnabled)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        s3BucketName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3KeyPrefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        snsTopicName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snsTopicName)
      .optionallyWith(
        trailArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.trailArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudTrailTrailDetails.wrap(buildAwsValue())
}
object AwsCloudTrailTrailDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudTrailTrailDetails =
      zio.aws.securityhub.model.AwsCloudTrailTrailDetails(
        cloudWatchLogsLogGroupArn.map(value => value),
        cloudWatchLogsRoleArn.map(value => value),
        hasCustomEventSelectors.map(value => value),
        homeRegion.map(value => value),
        includeGlobalServiceEvents.map(value => value),
        isMultiRegionTrail.map(value => value),
        isOrganizationTrail.map(value => value),
        kmsKeyId.map(value => value),
        logFileValidationEnabled.map(value => value),
        name.map(value => value),
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        snsTopicArn.map(value => value),
        snsTopicName.map(value => value),
        trailArn.map(value => value)
      )
    def cloudWatchLogsLogGroupArn: Option[NonEmptyString]
    def cloudWatchLogsRoleArn: Option[NonEmptyString]
    def hasCustomEventSelectors: Option[Boolean]
    def homeRegion: Option[NonEmptyString]
    def includeGlobalServiceEvents: Option[Boolean]
    def isMultiRegionTrail: Option[Boolean]
    def isOrganizationTrail: Option[Boolean]
    def kmsKeyId: Option[NonEmptyString]
    def logFileValidationEnabled: Option[Boolean]
    def name: Option[NonEmptyString]
    def s3BucketName: Option[NonEmptyString]
    def s3KeyPrefix: Option[NonEmptyString]
    def snsTopicArn: Option[NonEmptyString]
    def snsTopicName: Option[NonEmptyString]
    def trailArn: Option[NonEmptyString]
    def getCloudWatchLogsLogGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "cloudWatchLogsLogGroupArn",
        cloudWatchLogsLogGroupArn
      )
    def getCloudWatchLogsRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cloudWatchLogsRoleArn", cloudWatchLogsRoleArn)
    def getHasCustomEventSelectors: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("hasCustomEventSelectors", hasCustomEventSelectors)
    def getHomeRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("homeRegion", homeRegion)
    def getIncludeGlobalServiceEvents: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeGlobalServiceEvents",
        includeGlobalServiceEvents
      )
    def getIsMultiRegionTrail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMultiRegionTrail", isMultiRegionTrail)
    def getIsOrganizationTrail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isOrganizationTrail", isOrganizationTrail)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogFileValidationEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("logFileValidationEnabled", logFileValidationEnabled)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getS3BucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsTopicName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicName", snsTopicName)
    def getTrailArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("trailArn", trailArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
  ) extends zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Option[NonEmptyString] = scala
      .Option(impl.cloudWatchLogsLogGroupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cloudWatchLogsRoleArn: Option[NonEmptyString] = scala
      .Option(impl.cloudWatchLogsRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hasCustomEventSelectors: Option[Boolean] =
      scala.Option(impl.hasCustomEventSelectors()).map(value => value: Boolean)
    override val homeRegion: Option[NonEmptyString] = scala
      .Option(impl.homeRegion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val includeGlobalServiceEvents: Option[Boolean] = scala
      .Option(impl.includeGlobalServiceEvents())
      .map(value => value: Boolean)
    override val isMultiRegionTrail: Option[Boolean] =
      scala.Option(impl.isMultiRegionTrail()).map(value => value: Boolean)
    override val isOrganizationTrail: Option[Boolean] =
      scala.Option(impl.isOrganizationTrail()).map(value => value: Boolean)
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logFileValidationEnabled: Option[Boolean] =
      scala.Option(impl.logFileValidationEnabled()).map(value => value: Boolean)
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3BucketName: Option[NonEmptyString] = scala
      .Option(impl.s3BucketName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3KeyPrefix: Option[NonEmptyString] = scala
      .Option(impl.s3KeyPrefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snsTopicArn: Option[NonEmptyString] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snsTopicName: Option[NonEmptyString] = scala
      .Option(impl.snsTopicName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val trailArn: Option[NonEmptyString] = scala
      .Option(impl.trailArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
  ): zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly = new Wrapper(
    impl
  )
}
