package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayStageDetails(
    deploymentId: Option[NonEmptyString] = None,
    clientCertificateId: Option[NonEmptyString] = None,
    stageName: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    cacheClusterEnabled: Option[Boolean] = None,
    cacheClusterSize: Option[NonEmptyString] = None,
    cacheClusterStatus: Option[NonEmptyString] = None,
    methodSettings: Option[
      Iterable[zio.aws.securityhub.model.AwsApiGatewayMethodSettings]
    ] = None,
    variables: Option[Map[NonEmptyString, NonEmptyString]] = None,
    documentationVersion: Option[NonEmptyString] = None,
    accessLogSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings
    ] = None,
    canarySettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings
    ] = None,
    tracingEnabled: Option[Boolean] = None,
    createdDate: Option[NonEmptyString] = None,
    lastUpdatedDate: Option[NonEmptyString] = None,
    webAclArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails = {
    import AwsApiGatewayStageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
      .builder()
      .optionallyWith(
        deploymentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deploymentId)
      .optionallyWith(
        clientCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clientCertificateId)
      .optionallyWith(
        stageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        cacheClusterEnabled.map(value => value: java.lang.Boolean)
      )(_.cacheClusterEnabled)
      .optionallyWith(
        cacheClusterSize.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cacheClusterSize)
      .optionallyWith(
        cacheClusterStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cacheClusterStatus)
      .optionallyWith(
        methodSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.methodSettings)
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        documentationVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.documentationVersion)
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(canarySettings.map(value => value.buildAwsValue()))(
        _.canarySettings
      )
      .optionallyWith(tracingEnabled.map(value => value: java.lang.Boolean))(
        _.tracingEnabled
      )
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        lastUpdatedDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedDate)
      .optionallyWith(
        webAclArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.webAclArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayStageDetails.wrap(buildAwsValue())
}
object AwsApiGatewayStageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayStageDetails =
      zio.aws.securityhub.model.AwsApiGatewayStageDetails(
        deploymentId.map(value => value),
        clientCertificateId.map(value => value),
        stageName.map(value => value),
        description.map(value => value),
        cacheClusterEnabled.map(value => value),
        cacheClusterSize.map(value => value),
        cacheClusterStatus.map(value => value),
        methodSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        variables.map(value => value),
        documentationVersion.map(value => value),
        accessLogSettings.map(value => value.asEditable),
        canarySettings.map(value => value.asEditable),
        tracingEnabled.map(value => value),
        createdDate.map(value => value),
        lastUpdatedDate.map(value => value),
        webAclArn.map(value => value)
      )
    def deploymentId: Option[NonEmptyString]
    def clientCertificateId: Option[NonEmptyString]
    def stageName: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def cacheClusterEnabled: Option[Boolean]
    def cacheClusterSize: Option[NonEmptyString]
    def cacheClusterStatus: Option[NonEmptyString]
    def methodSettings: Option[
      List[zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly]
    ]
    def variables: Option[Map[NonEmptyString, NonEmptyString]]
    def documentationVersion: Option[NonEmptyString]
    def accessLogSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ]
    def canarySettings
        : Option[zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly]
    def tracingEnabled: Option[Boolean]
    def createdDate: Option[NonEmptyString]
    def lastUpdatedDate: Option[NonEmptyString]
    def webAclArn: Option[NonEmptyString]
    def getDeploymentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getClientCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getStageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCacheClusterEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheClusterEnabled", cacheClusterEnabled)
    def getCacheClusterSize: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cacheClusterSize", cacheClusterSize)
    def getCacheClusterStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cacheClusterStatus", cacheClusterStatus)
    def getMethodSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("methodSettings", methodSettings)
    def getVariables: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("variables", variables)
    def getDocumentationVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("documentationVersion", documentationVersion)
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getCanarySettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly
    ] = AwsError.unwrapOptionField("canarySettings", canarySettings)
    def getTracingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("tracingEnabled", tracingEnabled)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getWebAclArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("webAclArn", webAclArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly {
    override val deploymentId: Option[NonEmptyString] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clientCertificateId: Option[NonEmptyString] = scala
      .Option(impl.clientCertificateId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stageName: Option[NonEmptyString] = scala
      .Option(impl.stageName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cacheClusterEnabled: Option[Boolean] =
      scala.Option(impl.cacheClusterEnabled()).map(value => value: Boolean)
    override val cacheClusterSize: Option[NonEmptyString] = scala
      .Option(impl.cacheClusterSize())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cacheClusterStatus: Option[NonEmptyString] = scala
      .Option(impl.cacheClusterStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val methodSettings: Option[
      List[zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly]
    ] = scala
      .Option(impl.methodSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsApiGatewayMethodSettings.wrap(item)
        }.toList
      )
    override val variables: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val documentationVersion: Option[NonEmptyString] = scala
      .Option(impl.documentationVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accessLogSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = scala
      .Option(impl.accessLogSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.wrap(value)
      )
    override val canarySettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly
    ] = scala
      .Option(impl.canarySettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayCanarySettings.wrap(value)
      )
    override val tracingEnabled: Option[Boolean] =
      scala.Option(impl.tracingEnabled()).map(value => value: Boolean)
    override val createdDate: Option[NonEmptyString] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastUpdatedDate: Option[NonEmptyString] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val webAclArn: Option[NonEmptyString] = scala
      .Option(impl.webAclArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
  ): zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly = new Wrapper(
    impl
  )
}
