package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayRestApiDetails(
    id: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    createdDate: Option[NonEmptyString] = None,
    version: Option[NonEmptyString] = None,
    binaryMediaTypes: Option[Iterable[NonEmptyString]] = None,
    minimumCompressionSize: Option[Integer] = None,
    apiKeySource: Option[NonEmptyString] = None,
    endpointConfiguration: Option[
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails = {
    import AwsApiGatewayRestApiDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        binaryMediaTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.binaryMediaTypes)
      .optionallyWith(
        minimumCompressionSize.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.minimumCompressionSize)
      .optionallyWith(
        apiKeySource.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.apiKeySource)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.wrap(buildAwsValue())
}
object AwsApiGatewayRestApiDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayRestApiDetails =
      zio.aws.securityhub.model.AwsApiGatewayRestApiDetails(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        version.map(value => value),
        binaryMediaTypes.map(value => value),
        minimumCompressionSize.map(value => value),
        apiKeySource.map(value => value),
        endpointConfiguration.map(value => value.asEditable)
      )
    def id: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def createdDate: Option[NonEmptyString]
    def version: Option[NonEmptyString]
    def binaryMediaTypes: Option[List[NonEmptyString]]
    def minimumCompressionSize: Option[Integer]
    def apiKeySource: Option[NonEmptyString]
    def endpointConfiguration: Option[
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getBinaryMediaTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("binaryMediaTypes", binaryMediaTypes)
    def getMinimumCompressionSize: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("minimumCompressionSize", minimumCompressionSize)
    def getApiKeySource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiKeySource", apiKeySource)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdDate: Option[NonEmptyString] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val binaryMediaTypes: Option[List[NonEmptyString]] = scala
      .Option(impl.binaryMediaTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val minimumCompressionSize: Option[Integer] = scala
      .Option(impl.minimumCompressionSize())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val apiKeySource: Option[NonEmptyString] = scala
      .Option(impl.apiKeySource())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointConfiguration: Option[
      zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.ReadOnly
    ] = scala
      .Option(impl.endpointConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayEndpointConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayRestApiDetails
  ): zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly =
    new Wrapper(impl)
}
