package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Vulnerability(
    id: NonEmptyString,
    vulnerablePackages: Option[
      Iterable[zio.aws.securityhub.model.SoftwarePackage]
    ] = None,
    cvss: Option[Iterable[zio.aws.securityhub.model.Cvss]] = None,
    relatedVulnerabilities: Option[Iterable[NonEmptyString]] = None,
    vendor: Option[zio.aws.securityhub.model.VulnerabilityVendor] = None,
    referenceUrls: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Vulnerability = {
    import Vulnerability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Vulnerability
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(
        vulnerablePackages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerablePackages)
      .optionallyWith(
        cvss.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cvss)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .optionallyWith(vendor.map(value => value.buildAwsValue()))(_.vendor)
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Vulnerability.ReadOnly =
    zio.aws.securityhub.model.Vulnerability.wrap(buildAwsValue())
}
object Vulnerability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Vulnerability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Vulnerability =
      zio.aws.securityhub.model.Vulnerability(
        id,
        vulnerablePackages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cvss.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedVulnerabilities.map(value => value),
        vendor.map(value => value.asEditable),
        referenceUrls.map(value => value)
      )
    def id: NonEmptyString
    def vulnerablePackages
        : Option[List[zio.aws.securityhub.model.SoftwarePackage.ReadOnly]]
    def cvss: Option[List[zio.aws.securityhub.model.Cvss.ReadOnly]]
    def relatedVulnerabilities: Option[List[NonEmptyString]]
    def vendor: Option[zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly]
    def referenceUrls: Option[List[NonEmptyString]]
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getVulnerablePackages: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SoftwarePackage.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerablePackages", vulnerablePackages)
    def getCvss
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Cvss.ReadOnly]] =
      AwsError.unwrapOptionField("cvss", cvss)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "relatedVulnerabilities",
        relatedVulnerabilities
      )
    def getVendor: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly
    ] = AwsError.unwrapOptionField("vendor", vendor)
    def getReferenceUrls: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Vulnerability
  ) extends zio.aws.securityhub.model.Vulnerability.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val vulnerablePackages
        : Option[List[zio.aws.securityhub.model.SoftwarePackage.ReadOnly]] =
      scala
        .Option(impl.vulnerablePackages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.SoftwarePackage.wrap(item)
          }.toList
        )
    override val cvss: Option[List[zio.aws.securityhub.model.Cvss.ReadOnly]] =
      scala
        .Option(impl.cvss())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Cvss.wrap(item)
          }.toList
        )
    override val relatedVulnerabilities: Option[List[NonEmptyString]] = scala
      .Option(impl.relatedVulnerabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val vendor
        : Option[zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly] = scala
      .Option(impl.vendor())
      .map(value => zio.aws.securityhub.model.VulnerabilityVendor.wrap(value))
    override val referenceUrls: Option[List[NonEmptyString]] = scala
      .Option(impl.referenceUrls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Vulnerability
  ): zio.aws.securityhub.model.Vulnerability.ReadOnly = new Wrapper(impl)
}
