package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStandardsControlRequest(
    standardsControlArn: NonEmptyString,
    controlStatus: Option[zio.aws.securityhub.model.ControlStatus] = None,
    disabledReason: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest = {
    import UpdateStandardsControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest
      .builder()
      .standardsControlArn(
        NonEmptyString.unwrap(standardsControlArn): java.lang.String
      )
      .optionallyWith(controlStatus.map(value => value.unwrap))(_.controlStatus)
      .optionallyWith(
        disabledReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.disabledReason)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UpdateStandardsControlRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateStandardsControlRequest
      .wrap(buildAwsValue())
}
object UpdateStandardsControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateStandardsControlRequest =
      zio.aws.securityhub.model.UpdateStandardsControlRequest(
        standardsControlArn,
        controlStatus.map(value => value),
        disabledReason.map(value => value)
      )
    def standardsControlArn: NonEmptyString
    def controlStatus: Option[zio.aws.securityhub.model.ControlStatus]
    def disabledReason: Option[NonEmptyString]
    def getStandardsControlArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsControlArn)
    def getControlStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.ControlStatus] =
      AwsError.unwrapOptionField("controlStatus", controlStatus)
    def getDisabledReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest
  ) extends zio.aws.securityhub.model.UpdateStandardsControlRequest.ReadOnly {
    override val standardsControlArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.standardsControlArn())
    override val controlStatus
        : Option[zio.aws.securityhub.model.ControlStatus] = scala
      .Option(impl.controlStatus())
      .map(value => zio.aws.securityhub.model.ControlStatus.wrap(value))
    override val disabledReason: Option[NonEmptyString] = scala
      .Option(impl.disabledReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest
  ): zio.aws.securityhub.model.UpdateStandardsControlRequest.ReadOnly =
    new Wrapper(impl)
}
