package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StandardsSubscriptionRequest(
    standardsArn: NonEmptyString,
    standardsInput: Option[Map[NonEmptyString, NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequest = {
    import StandardsSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequest
      .builder()
      .standardsArn(NonEmptyString.unwrap(standardsArn): java.lang.String)
      .optionallyWith(
        standardsInput.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.standardsInput)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StandardsSubscriptionRequest.ReadOnly =
    zio.aws.securityhub.model.StandardsSubscriptionRequest.wrap(buildAwsValue())
}
object StandardsSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsSubscriptionRequest =
      zio.aws.securityhub.model.StandardsSubscriptionRequest(
        standardsArn,
        standardsInput.map(value => value)
      )
    def standardsArn: NonEmptyString
    def standardsInput: Option[Map[NonEmptyString, NonEmptyString]]
    def getStandardsArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsArn)
    def getStandardsInput
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("standardsInput", standardsInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequest
  ) extends zio.aws.securityhub.model.StandardsSubscriptionRequest.ReadOnly {
    override val standardsArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.standardsArn())
    override val standardsInput: Option[Map[NonEmptyString, NonEmptyString]] =
      scala
        .Option(impl.standardsInput())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequest
  ): zio.aws.securityhub.model.StandardsSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
