package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupVariablesPortSetsDetails(
    definition: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesPortSetsDetails = {
    import RuleGroupVariablesPortSetsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesPortSetsDetails
      .builder()
      .optionallyWith(
        definition.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.definition)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails
      .wrap(buildAwsValue())
}
object RuleGroupVariablesPortSetsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesPortSetsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails =
      zio.aws.securityhub.model
        .RuleGroupVariablesPortSetsDetails(definition.map(value => value))
    def definition: Option[List[NonEmptyString]]
    def getDefinition: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("definition", definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesPortSetsDetails
  ) extends zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly {
    override val definition: Option[List[NonEmptyString]] = scala
      .Option(impl.definition())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariablesPortSetsDetails
  ): zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly =
    new Wrapper(impl)
}
