package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRulesAndCustomActionsDetails(
    customActions: Option[
      Iterable[zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails]
    ] = None,
    statelessRules: Option[
      Iterable[zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails = {
    import RuleGroupSourceStatelessRulesAndCustomActionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
      .builder()
      .optionallyWith(
        customActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customActions)
      .optionallyWith(
        statelessRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRulesAndCustomActionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails =
      zio.aws.securityhub.model
        .RuleGroupSourceStatelessRulesAndCustomActionsDetails(
          customActions.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          statelessRules.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def customActions: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails.ReadOnly
    ]]
    def statelessRules: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly
    ]]
    def getCustomActions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("customActions", customActions)
    def getStatelessRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("statelessRules", statelessRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly {
    override val customActions: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails.ReadOnly
    ]] = scala
      .Option(impl.customActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails
            .wrap(item)
        }.toList
      )
    override val statelessRules: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly
    ]] = scala
      .Option(impl.statelessRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly =
    new Wrapper(impl)
}
