package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRuleMatchAttributesSources(
    addressDefinition: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources = {
    import RuleGroupSourceStatelessRuleMatchAttributesSources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
      .builder()
      .optionallyWith(
        addressDefinition.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.addressDefinition)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRuleMatchAttributesSources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources =
      zio.aws.securityhub.model
        .RuleGroupSourceStatelessRuleMatchAttributesSources(
          addressDefinition.map(value => value)
        )
    def addressDefinition: Option[NonEmptyString]
    def getAddressDefinition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("addressDefinition", addressDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.ReadOnly {
    override val addressDefinition: Option[NonEmptyString] = scala
      .Option(impl.addressDefinition())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.ReadOnly =
    new Wrapper(impl)
}
