package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Recommendation(
    text: Option[NonEmptyString] = None,
    url: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Recommendation
      .builder()
      .optionallyWith(
        text.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.text)
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Recommendation.ReadOnly =
    zio.aws.securityhub.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Recommendation =
      zio.aws.securityhub.model
        .Recommendation(text.map(value => value), url.map(value => value))
    def text: Option[NonEmptyString]
    def url: Option[NonEmptyString]
    def getText: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("text", text)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Recommendation
  ) extends zio.aws.securityhub.model.Recommendation.ReadOnly {
    override val text: Option[NonEmptyString] = scala
      .Option(impl.text())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val url: Option[NonEmptyString] = scala
      .Option(impl.url())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Recommendation
  ): zio.aws.securityhub.model.Recommendation.ReadOnly = new Wrapper(impl)
}
