package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Range(
    start: Option[Long] = None,
    end: Option[Long] = None,
    startColumn: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Range
      .builder()
      .optionallyWith(start.map(value => value: java.lang.Long))(_.start)
      .optionallyWith(end.map(value => value: java.lang.Long))(_.end)
      .optionallyWith(startColumn.map(value => value: java.lang.Long))(
        _.startColumn
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Range.ReadOnly =
    zio.aws.securityhub.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Range =
      zio.aws.securityhub.model.Range(
        start.map(value => value),
        end.map(value => value),
        startColumn.map(value => value)
      )
    def start: Option[Long]
    def end: Option[Long]
    def startColumn: Option[Long]
    def getStart: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("end", end)
    def getStartColumn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startColumn", startColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Range
  ) extends zio.aws.securityhub.model.Range.ReadOnly {
    override val start: Option[Long] =
      scala.Option(impl.start()).map(value => value: Long)
    override val end: Option[Long] =
      scala.Option(impl.end()).map(value => value: Long)
    override val startColumn: Option[Long] =
      scala.Option(impl.startColumn()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Range
  ): zio.aws.securityhub.model.Range.ReadOnly = new Wrapper(impl)
}
