package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Note(
    text: NonEmptyString,
    updatedBy: NonEmptyString,
    updatedAt: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Note = {
    import Note.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Note
      .builder()
      .text(NonEmptyString.unwrap(text): java.lang.String)
      .updatedBy(NonEmptyString.unwrap(updatedBy): java.lang.String)
      .updatedAt(NonEmptyString.unwrap(updatedAt): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Note.ReadOnly =
    zio.aws.securityhub.model.Note.wrap(buildAwsValue())
}
object Note {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Note] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Note =
      zio.aws.securityhub.model.Note(text, updatedBy, updatedAt)
    def text: NonEmptyString
    def updatedBy: NonEmptyString
    def updatedAt: NonEmptyString
    def getText: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(text)
    def getUpdatedBy: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(updatedBy)
    def getUpdatedAt: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Note
  ) extends zio.aws.securityhub.model.Note.ReadOnly {
    override val text: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.text())
    override val updatedBy: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.updatedBy())
    override val updatedAt: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Note
  ): zio.aws.securityhub.model.Note.ReadOnly = new Wrapper(impl)
}
