package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Network(
    direction: Option[zio.aws.securityhub.model.NetworkDirection] = None,
    protocol: Option[NonEmptyString] = None,
    openPortRange: Option[zio.aws.securityhub.model.PortRange] = None,
    sourceIpV4: Option[NonEmptyString] = None,
    sourceIpV6: Option[NonEmptyString] = None,
    sourcePort: Option[Integer] = None,
    sourceDomain: Option[NonEmptyString] = None,
    sourceMac: Option[NonEmptyString] = None,
    destinationIpV4: Option[NonEmptyString] = None,
    destinationIpV6: Option[NonEmptyString] = None,
    destinationPort: Option[Integer] = None,
    destinationDomain: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Network = {
    import Network.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Network
      .builder()
      .optionallyWith(direction.map(value => value.unwrap))(_.direction)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(openPortRange.map(value => value.buildAwsValue()))(
        _.openPortRange
      )
      .optionallyWith(
        sourceIpV4.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceIpV4)
      .optionallyWith(
        sourceIpV6.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceIpV6)
      .optionallyWith(
        sourcePort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sourcePort)
      .optionallyWith(
        sourceDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceDomain)
      .optionallyWith(
        sourceMac.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceMac)
      .optionallyWith(
        destinationIpV4.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationIpV4)
      .optionallyWith(
        destinationIpV6.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationIpV6)
      .optionallyWith(
        destinationPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.destinationPort)
      .optionallyWith(
        destinationDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationDomain)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Network.ReadOnly =
    zio.aws.securityhub.model.Network.wrap(buildAwsValue())
}
object Network {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Network
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Network =
      zio.aws.securityhub.model.Network(
        direction.map(value => value),
        protocol.map(value => value),
        openPortRange.map(value => value.asEditable),
        sourceIpV4.map(value => value),
        sourceIpV6.map(value => value),
        sourcePort.map(value => value),
        sourceDomain.map(value => value),
        sourceMac.map(value => value),
        destinationIpV4.map(value => value),
        destinationIpV6.map(value => value),
        destinationPort.map(value => value),
        destinationDomain.map(value => value)
      )
    def direction: Option[zio.aws.securityhub.model.NetworkDirection]
    def protocol: Option[NonEmptyString]
    def openPortRange: Option[zio.aws.securityhub.model.PortRange.ReadOnly]
    def sourceIpV4: Option[NonEmptyString]
    def sourceIpV6: Option[NonEmptyString]
    def sourcePort: Option[Integer]
    def sourceDomain: Option[NonEmptyString]
    def sourceMac: Option[NonEmptyString]
    def destinationIpV4: Option[NonEmptyString]
    def destinationIpV6: Option[NonEmptyString]
    def destinationPort: Option[Integer]
    def destinationDomain: Option[NonEmptyString]
    def getDirection
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NetworkDirection] =
      AwsError.unwrapOptionField("direction", direction)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getOpenPortRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("openPortRange", openPortRange)
    def getSourceIpV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceIpV4", sourceIpV4)
    def getSourceIpV6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceIpV6", sourceIpV6)
    def getSourcePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sourcePort", sourcePort)
    def getSourceDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceDomain", sourceDomain)
    def getSourceMac: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceMac", sourceMac)
    def getDestinationIpV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationIpV4", destinationIpV4)
    def getDestinationIpV6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationIpV6", destinationIpV6)
    def getDestinationPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getDestinationDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationDomain", destinationDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Network
  ) extends zio.aws.securityhub.model.Network.ReadOnly {
    override val direction: Option[zio.aws.securityhub.model.NetworkDirection] =
      scala
        .Option(impl.direction())
        .map(value => zio.aws.securityhub.model.NetworkDirection.wrap(value))
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val openPortRange
        : Option[zio.aws.securityhub.model.PortRange.ReadOnly] = scala
      .Option(impl.openPortRange())
      .map(value => zio.aws.securityhub.model.PortRange.wrap(value))
    override val sourceIpV4: Option[NonEmptyString] = scala
      .Option(impl.sourceIpV4())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceIpV6: Option[NonEmptyString] = scala
      .Option(impl.sourceIpV6())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourcePort: Option[Integer] = scala
      .Option(impl.sourcePort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val sourceDomain: Option[NonEmptyString] = scala
      .Option(impl.sourceDomain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceMac: Option[NonEmptyString] = scala
      .Option(impl.sourceMac())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationIpV4: Option[NonEmptyString] = scala
      .Option(impl.destinationIpV4())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationIpV6: Option[NonEmptyString] = scala
      .Option(impl.destinationIpV6())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationPort: Option[Integer] = scala
      .Option(impl.destinationPort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val destinationDomain: Option[NonEmptyString] = scala
      .Option(impl.destinationDomain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Network
  ): zio.aws.securityhub.model.Network.ReadOnly = new Wrapper(impl)
}
