package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancerState(
    code: Option[NonEmptyString] = None,
    reason: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.LoadBalancerState = {
    import LoadBalancerState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.LoadBalancerState
      .builder()
      .optionallyWith(
        code.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.LoadBalancerState.ReadOnly =
    zio.aws.securityhub.model.LoadBalancerState.wrap(buildAwsValue())
}
object LoadBalancerState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.LoadBalancerState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.LoadBalancerState =
      zio.aws.securityhub.model
        .LoadBalancerState(code.map(value => value), reason.map(value => value))
    def code: Option[NonEmptyString]
    def reason: Option[NonEmptyString]
    def getCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("code", code)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.LoadBalancerState
  ) extends zio.aws.securityhub.model.LoadBalancerState.ReadOnly {
    override val code: Option[NonEmptyString] = scala
      .Option(impl.code())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val reason: Option[NonEmptyString] = scala
      .Option(impl.reason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.LoadBalancerState
  ): zio.aws.securityhub.model.LoadBalancerState.ReadOnly = new Wrapper(impl)
}
