package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOrganizationAdminAccountsResponse(
    adminAccounts: Option[Iterable[zio.aws.securityhub.model.AdminAccount]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse = {
    import ListOrganizationAdminAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse
      .builder()
      .optionallyWith(
        adminAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adminAccounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse =
      zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse(
        adminAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def adminAccounts
        : Option[List[zio.aws.securityhub.model.AdminAccount.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAdminAccounts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AdminAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("adminAccounts", adminAccounts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse
  ) extends zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly {
    override val adminAccounts
        : Option[List[zio.aws.securityhub.model.AdminAccount.ReadOnly]] = scala
      .Option(impl.adminAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AdminAccount.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse
  ): zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
