package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMembersResponse(
    members: Option[Iterable[zio.aws.securityhub.model.Member]] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ListMembersResponse.ReadOnly =
    zio.aws.securityhub.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListMembersResponse =
      zio.aws.securityhub.model.ListMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members: Option[List[zio.aws.securityhub.model.Member.ReadOnly]]
    def nextToken: Option[NonEmptyString]
    def getMembers
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Member.ReadOnly]] =
      AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListMembersResponse
  ) extends zio.aws.securityhub.model.ListMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.securityhub.model.Member.ReadOnly]] = scala
      .Option(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Member.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListMembersResponse
  ): zio.aws.securityhub.model.ListMembersResponse.ReadOnly = new Wrapper(impl)
}
