package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NextToken, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnabledProductsForImportResponse(
    productSubscriptions: Option[Iterable[NonEmptyString]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse = {
    import ListEnabledProductsForImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse
      .builder()
      .optionallyWith(
        productSubscriptions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.productSubscriptions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly =
    zio.aws.securityhub.model.ListEnabledProductsForImportResponse
      .wrap(buildAwsValue())
}
object ListEnabledProductsForImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListEnabledProductsForImportResponse =
      zio.aws.securityhub.model.ListEnabledProductsForImportResponse(
        productSubscriptions.map(value => value),
        nextToken.map(value => value)
      )
    def productSubscriptions: Option[List[NonEmptyString]]
    def nextToken: Option[NextToken]
    def getProductSubscriptions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("productSubscriptions", productSubscriptions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse
  ) extends zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly {
    override val productSubscriptions: Option[List[NonEmptyString]] = scala
      .Option(impl.productSubscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse
  ): zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly =
    new Wrapper(impl)
}
