package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Insight(
    insightArn: NonEmptyString,
    name: NonEmptyString,
    filters: zio.aws.securityhub.model.AwsSecurityFindingFilters,
    groupByAttribute: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Insight = {
    import Insight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Insight
      .builder()
      .insightArn(NonEmptyString.unwrap(insightArn): java.lang.String)
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .filters(filters.buildAwsValue())
      .groupByAttribute(
        NonEmptyString.unwrap(groupByAttribute): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Insight.ReadOnly =
    zio.aws.securityhub.model.Insight.wrap(buildAwsValue())
}
object Insight {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Insight
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Insight =
      zio.aws.securityhub.model.Insight(
        insightArn,
        name,
        filters.asEditable,
        groupByAttribute
      )
    def insightArn: NonEmptyString
    def name: NonEmptyString
    def filters: zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    def groupByAttribute: NonEmptyString
    def getInsightArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(insightArn)
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getGroupByAttribute: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(groupByAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Insight
  ) extends zio.aws.securityhub.model.Insight.ReadOnly {
    override val insightArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.insightArn())
    override val name: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.name())
    override val filters
        : zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly =
      zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(impl.filters())
    override val groupByAttribute: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.groupByAttribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Insight
  ): zio.aws.securityhub.model.Insight.ReadOnly = new Wrapper(impl)
}
