package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFindingsRequest(
    filters: Option[zio.aws.securityhub.model.AwsSecurityFindingFilters] = None,
    sortCriteria: Option[Iterable[zio.aws.securityhub.model.SortCriterion]] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetFindingsRequest = {
    import GetFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        sortCriteria.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortCriteria)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetFindingsRequest.ReadOnly =
    zio.aws.securityhub.model.GetFindingsRequest.wrap(buildAwsValue())
}
object GetFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetFindingsRequest =
      zio.aws.securityhub.model.GetFindingsRequest(
        filters.map(value => value.asEditable),
        sortCriteria.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters
        : Option[zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly]
    def sortCriteria
        : Option[List[zio.aws.securityhub.model.SortCriterion.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getSortCriteria: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SortCriterion.ReadOnly
    ]] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
  ) extends zio.aws.securityhub.model.GetFindingsRequest.ReadOnly {
    override val filters
        : Option[zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly] =
      scala
        .Option(impl.filters())
        .map(value =>
          zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(value)
        )
    override val sortCriteria
        : Option[List[zio.aws.securityhub.model.SortCriterion.ReadOnly]] = scala
      .Option(impl.sortCriteria())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.SortCriterion.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
  ): zio.aws.securityhub.model.GetFindingsRequest.ReadOnly = new Wrapper(impl)
}
