package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  NonEmptyString,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProductsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    productArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest = {
    import DescribeProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        productArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.productArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeProductsRequest.ReadOnly =
    zio.aws.securityhub.model.DescribeProductsRequest.wrap(buildAwsValue())
}
object DescribeProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeProductsRequest =
      zio.aws.securityhub.model.DescribeProductsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        productArn.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def productArn: Option[NonEmptyString]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getProductArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("productArn", productArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
  ) extends zio.aws.securityhub.model.DescribeProductsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
    override val productArn: Option[NonEmptyString] = scala
      .Option(impl.productArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest
  ): zio.aws.securityhub.model.DescribeProductsRequest.ReadOnly = new Wrapper(
    impl
  )
}
