package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeActionTargetsResponse(
    actionTargets: Iterable[zio.aws.securityhub.model.ActionTarget],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse = {
    import DescribeActionTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse
      .builder()
      .actionTargets(actionTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeActionTargetsResponse
      .wrap(buildAwsValue())
}
object DescribeActionTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeActionTargetsResponse =
      zio.aws.securityhub.model.DescribeActionTargetsResponse(
        actionTargets.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def actionTargets: List[zio.aws.securityhub.model.ActionTarget.ReadOnly]
    def nextToken: Option[NextToken]
    def getActionTargets: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.ActionTarget.ReadOnly
    ]] = ZIO.succeed(actionTargets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse
  ) extends zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly {
    override val actionTargets
        : List[zio.aws.securityhub.model.ActionTarget.ReadOnly] = impl
      .actionTargets()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.ActionTarget.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse
  ): zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
