package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInvitationsRequest(
    accountIds: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest = {
    import DeleteInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeleteInvitationsRequest.ReadOnly =
    zio.aws.securityhub.model.DeleteInvitationsRequest.wrap(buildAwsValue())
}
object DeleteInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteInvitationsRequest =
      zio.aws.securityhub.model.DeleteInvitationsRequest(accountIds)
    def accountIds: List[NonEmptyString]
    def getAccountIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest
  ) extends zio.aws.securityhub.model.DeleteInvitationsRequest.ReadOnly {
    override val accountIds: List[NonEmptyString] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest
  ): zio.aws.securityhub.model.DeleteInvitationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
