package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateActionTargetRequest(
    name: NonEmptyString,
    description: NonEmptyString,
    id: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest = {
    import CreateActionTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .description(NonEmptyString.unwrap(description): java.lang.String)
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.CreateActionTargetRequest.ReadOnly =
    zio.aws.securityhub.model.CreateActionTargetRequest.wrap(buildAwsValue())
}
object CreateActionTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateActionTargetRequest =
      zio.aws.securityhub.model.CreateActionTargetRequest(name, description, id)
    def name: NonEmptyString
    def description: NonEmptyString
    def id: NonEmptyString
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(description)
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest
  ) extends zio.aws.securityhub.model.CreateActionTargetRequest.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.name())
    override val description: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.description())
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest
  ): zio.aws.securityhub.model.CreateActionTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
