package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CidrBlockAssociation(
    associationId: Option[NonEmptyString] = None,
    cidrBlock: Option[NonEmptyString] = None,
    cidrBlockState: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation = {
    import CidrBlockAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        cidrBlock.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .optionallyWith(
        cidrBlockState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cidrBlockState)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.CidrBlockAssociation.ReadOnly =
    zio.aws.securityhub.model.CidrBlockAssociation.wrap(buildAwsValue())
}
object CidrBlockAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CidrBlockAssociation =
      zio.aws.securityhub.model.CidrBlockAssociation(
        associationId.map(value => value),
        cidrBlock.map(value => value),
        cidrBlockState.map(value => value)
      )
    def associationId: Option[NonEmptyString]
    def cidrBlock: Option[NonEmptyString]
    def cidrBlockState: Option[NonEmptyString]
    def getAssociationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getCidrBlockState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlockState", cidrBlockState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation
  ) extends zio.aws.securityhub.model.CidrBlockAssociation.ReadOnly {
    override val associationId: Option[NonEmptyString] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cidrBlock: Option[NonEmptyString] = scala
      .Option(impl.cidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cidrBlockState: Option[NonEmptyString] = scala
      .Option(impl.cidrBlockState())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation
  ): zio.aws.securityhub.model.CidrBlockAssociation.ReadOnly = new Wrapper(impl)
}
