package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsSsmComplianceSummary(
    status: Option[NonEmptyString] = None,
    compliantCriticalCount: Option[Integer] = None,
    compliantHighCount: Option[Integer] = None,
    compliantMediumCount: Option[Integer] = None,
    executionType: Option[NonEmptyString] = None,
    nonCompliantCriticalCount: Option[Integer] = None,
    compliantInformationalCount: Option[Integer] = None,
    nonCompliantInformationalCount: Option[Integer] = None,
    compliantUnspecifiedCount: Option[Integer] = None,
    nonCompliantLowCount: Option[Integer] = None,
    nonCompliantHighCount: Option[Integer] = None,
    compliantLowCount: Option[Integer] = None,
    complianceType: Option[NonEmptyString] = None,
    patchBaselineId: Option[NonEmptyString] = None,
    overallSeverity: Option[NonEmptyString] = None,
    nonCompliantMediumCount: Option[Integer] = None,
    nonCompliantUnspecifiedCount: Option[Integer] = None,
    patchGroup: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary = {
    import AwsSsmComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
      .builder()
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        compliantCriticalCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantCriticalCount)
      .optionallyWith(
        compliantHighCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantHighCount)
      .optionallyWith(
        compliantMediumCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantMediumCount)
      .optionallyWith(
        executionType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.executionType)
      .optionallyWith(
        nonCompliantCriticalCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantCriticalCount)
      .optionallyWith(
        compliantInformationalCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantInformationalCount)
      .optionallyWith(
        nonCompliantInformationalCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantInformationalCount)
      .optionallyWith(
        compliantUnspecifiedCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantUnspecifiedCount)
      .optionallyWith(
        nonCompliantLowCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantLowCount)
      .optionallyWith(
        nonCompliantHighCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantHighCount)
      .optionallyWith(
        compliantLowCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.compliantLowCount)
      .optionallyWith(
        complianceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        patchBaselineId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.patchBaselineId)
      .optionallyWith(
        overallSeverity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.overallSeverity)
      .optionallyWith(
        nonCompliantMediumCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantMediumCount)
      .optionallyWith(
        nonCompliantUnspecifiedCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantUnspecifiedCount)
      .optionallyWith(
        patchGroup.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.patchGroup)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly =
    zio.aws.securityhub.model.AwsSsmComplianceSummary.wrap(buildAwsValue())
}
object AwsSsmComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSsmComplianceSummary =
      zio.aws.securityhub.model.AwsSsmComplianceSummary(
        status.map(value => value),
        compliantCriticalCount.map(value => value),
        compliantHighCount.map(value => value),
        compliantMediumCount.map(value => value),
        executionType.map(value => value),
        nonCompliantCriticalCount.map(value => value),
        compliantInformationalCount.map(value => value),
        nonCompliantInformationalCount.map(value => value),
        compliantUnspecifiedCount.map(value => value),
        nonCompliantLowCount.map(value => value),
        nonCompliantHighCount.map(value => value),
        compliantLowCount.map(value => value),
        complianceType.map(value => value),
        patchBaselineId.map(value => value),
        overallSeverity.map(value => value),
        nonCompliantMediumCount.map(value => value),
        nonCompliantUnspecifiedCount.map(value => value),
        patchGroup.map(value => value)
      )
    def status: Option[NonEmptyString]
    def compliantCriticalCount: Option[Integer]
    def compliantHighCount: Option[Integer]
    def compliantMediumCount: Option[Integer]
    def executionType: Option[NonEmptyString]
    def nonCompliantCriticalCount: Option[Integer]
    def compliantInformationalCount: Option[Integer]
    def nonCompliantInformationalCount: Option[Integer]
    def compliantUnspecifiedCount: Option[Integer]
    def nonCompliantLowCount: Option[Integer]
    def nonCompliantHighCount: Option[Integer]
    def compliantLowCount: Option[Integer]
    def complianceType: Option[NonEmptyString]
    def patchBaselineId: Option[NonEmptyString]
    def overallSeverity: Option[NonEmptyString]
    def nonCompliantMediumCount: Option[Integer]
    def nonCompliantUnspecifiedCount: Option[Integer]
    def patchGroup: Option[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getCompliantCriticalCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("compliantCriticalCount", compliantCriticalCount)
    def getCompliantHighCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantHighCount", compliantHighCount)
    def getCompliantMediumCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantMediumCount", compliantMediumCount)
    def getExecutionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("executionType", executionType)
    def getNonCompliantCriticalCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("nonCompliantCriticalCount", nonCompliantCriticalCount)
    def getCompliantInformationalCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "compliantInformationalCount",
        compliantInformationalCount
      )
    def getNonCompliantInformationalCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "nonCompliantInformationalCount",
        nonCompliantInformationalCount
      )
    def getCompliantUnspecifiedCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("compliantUnspecifiedCount", compliantUnspecifiedCount)
    def getNonCompliantLowCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nonCompliantLowCount", nonCompliantLowCount)
    def getNonCompliantHighCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nonCompliantHighCount", nonCompliantHighCount)
    def getCompliantLowCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantLowCount", compliantLowCount)
    def getComplianceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getPatchBaselineId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("patchBaselineId", patchBaselineId)
    def getOverallSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("overallSeverity", overallSeverity)
    def getNonCompliantMediumCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("nonCompliantMediumCount", nonCompliantMediumCount)
    def getNonCompliantUnspecifiedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "nonCompliantUnspecifiedCount",
        nonCompliantUnspecifiedCount
      )
    def getPatchGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("patchGroup", patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
  ) extends zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly {
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val compliantCriticalCount: Option[Integer] = scala
      .Option(impl.compliantCriticalCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val compliantHighCount: Option[Integer] = scala
      .Option(impl.compliantHighCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val compliantMediumCount: Option[Integer] = scala
      .Option(impl.compliantMediumCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val executionType: Option[NonEmptyString] = scala
      .Option(impl.executionType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nonCompliantCriticalCount: Option[Integer] = scala
      .Option(impl.nonCompliantCriticalCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val compliantInformationalCount: Option[Integer] = scala
      .Option(impl.compliantInformationalCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val nonCompliantInformationalCount: Option[Integer] = scala
      .Option(impl.nonCompliantInformationalCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val compliantUnspecifiedCount: Option[Integer] = scala
      .Option(impl.compliantUnspecifiedCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val nonCompliantLowCount: Option[Integer] = scala
      .Option(impl.nonCompliantLowCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val nonCompliantHighCount: Option[Integer] = scala
      .Option(impl.nonCompliantHighCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val compliantLowCount: Option[Integer] = scala
      .Option(impl.compliantLowCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val complianceType: Option[NonEmptyString] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val patchBaselineId: Option[NonEmptyString] = scala
      .Option(impl.patchBaselineId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val overallSeverity: Option[NonEmptyString] = scala
      .Option(impl.overallSeverity())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nonCompliantMediumCount: Option[Integer] = scala
      .Option(impl.nonCompliantMediumCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val nonCompliantUnspecifiedCount: Option[Integer] = scala
      .Option(impl.nonCompliantUnspecifiedCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val patchGroup: Option[NonEmptyString] = scala
      .Option(impl.patchGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
  ): zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly = new Wrapper(
    impl
  )
}
