package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketServerSideEncryptionRule(
    applyServerSideEncryptionByDefault: Option[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionRule = {
    import AwsS3BucketServerSideEncryptionRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionRule
      .builder()
      .optionallyWith(
        applyServerSideEncryptionByDefault.map(value => value.buildAwsValue())
      )(_.applyServerSideEncryptionByDefault)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule
      .wrap(buildAwsValue())
}
object AwsS3BucketServerSideEncryptionRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule =
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule(
        applyServerSideEncryptionByDefault.map(value => value.asEditable)
      )
    def applyServerSideEncryptionByDefault: Option[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault.ReadOnly
    ]
    def getApplyServerSideEncryptionByDefault: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applyServerSideEncryptionByDefault",
      applyServerSideEncryptionByDefault
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionRule
  ) extends zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule.ReadOnly {
    override val applyServerSideEncryptionByDefault: Option[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault.ReadOnly
    ] = scala
      .Option(impl.applyServerSideEncryptionByDefault())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionRule
  ): zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionRule.ReadOnly =
    new Wrapper(impl)
}
