package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketNotificationConfigurationS3KeyFilter(
    filterRules: Option[Iterable[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter = {
    import AwsS3BucketNotificationConfigurationS3KeyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
      .builder()
      .optionallyWith(
        filterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterRules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
      .wrap(buildAwsValue())
}
object AwsS3BucketNotificationConfigurationS3KeyFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter =
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter(
        filterRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filterRules: Option[List[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.ReadOnly
    ]]
    def getFilterRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.ReadOnly
    ]] = AwsError.unwrapOptionField("filterRules", filterRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
  ) extends zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter.ReadOnly {
    override val filterRules: Option[List[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.ReadOnly
    ]] = scala
      .Option(impl.filterRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter
  ): zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilter.ReadOnly =
    new Wrapper(impl)
}
