package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketNotificationConfigurationDetail(
    events: Option[Iterable[NonEmptyString]] = None,
    filter: Option[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter
    ] = None,
    destination: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationDetail = {
    import AwsS3BucketNotificationConfigurationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationDetail
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        destination.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail
      .wrap(buildAwsValue())
}
object AwsS3BucketNotificationConfigurationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail =
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail(
        events.map(value => value),
        filter.map(value => value.asEditable),
        destination.map(value => value),
        `type`.map(value => value)
      )
    def events: Option[List[NonEmptyString]]
    def filter: Option[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter.ReadOnly
    ]
    def destination: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getEvents: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("events", events)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getDestination: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destination", destination)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationDetail
  ) extends zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail.ReadOnly {
    override val events: Option[List[NonEmptyString]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val filter: Option[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationFilter
          .wrap(value)
      )
    override val destination: Option[NonEmptyString] = scala
      .Option(impl.destination())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationDetail
  ): zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail.ReadOnly =
    new Wrapper(impl)
}
