package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterEndpoint(
    address: Option[NonEmptyString] = None,
    port: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint = {
    import AwsRedshiftClusterEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
      .builder()
      .optionallyWith(
        address.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.wrap(buildAwsValue())
}
object AwsRedshiftClusterEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterEndpoint =
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint(
        address.map(value => value),
        port.map(value => value)
      )
    def address: Option[NonEmptyString]
    def port: Option[Integer]
    def getAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly {
    override val address: Option[NonEmptyString] = scala
      .Option(impl.address())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
  ): zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly =
    new Wrapper(impl)
}
