package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterDetails(
    allowVersionUpgrade: Option[Boolean] = None,
    automatedSnapshotRetentionPeriod: Option[Integer] = None,
    availabilityZone: Option[NonEmptyString] = None,
    clusterAvailabilityStatus: Option[NonEmptyString] = None,
    clusterCreateTime: Option[NonEmptyString] = None,
    clusterIdentifier: Option[NonEmptyString] = None,
    clusterNodes: Option[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode]
    ] = None,
    clusterParameterGroups: Option[Iterable[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup
    ]] = None,
    clusterPublicKey: Option[NonEmptyString] = None,
    clusterRevisionNumber: Option[NonEmptyString] = None,
    clusterSecurityGroups: Option[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup]
    ] = None,
    clusterSnapshotCopyStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
    ] = None,
    clusterStatus: Option[NonEmptyString] = None,
    clusterSubnetGroupName: Option[NonEmptyString] = None,
    clusterVersion: Option[NonEmptyString] = None,
    dbName: Option[NonEmptyString] = None,
    deferredMaintenanceWindows: Option[Iterable[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
    ]] = None,
    elasticIpStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus
    ] = None,
    elasticResizeNumberOfNodeOptions: Option[NonEmptyString] = None,
    encrypted: Option[Boolean] = None,
    endpoint: Option[zio.aws.securityhub.model.AwsRedshiftClusterEndpoint] =
      None,
    enhancedVpcRouting: Option[Boolean] = None,
    expectedNextSnapshotScheduleTime: Option[NonEmptyString] = None,
    expectedNextSnapshotScheduleTimeStatus: Option[NonEmptyString] = None,
    hsmStatus: Option[zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus] =
      None,
    iamRoles: Option[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterIamRole]
    ] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    maintenanceTrackName: Option[NonEmptyString] = None,
    manualSnapshotRetentionPeriod: Option[Integer] = None,
    masterUsername: Option[NonEmptyString] = None,
    nextMaintenanceWindowStartTime: Option[NonEmptyString] = None,
    nodeType: Option[NonEmptyString] = None,
    numberOfNodes: Option[Integer] = None,
    pendingActions: Option[Iterable[NonEmptyString]] = None,
    pendingModifiedValues: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues
    ] = None,
    preferredMaintenanceWindow: Option[NonEmptyString] = None,
    publiclyAccessible: Option[Boolean] = None,
    resizeInfo: Option[zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo] =
      None,
    restoreStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus
    ] = None,
    snapshotScheduleIdentifier: Option[NonEmptyString] = None,
    snapshotScheduleState: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails = {
    import AwsRedshiftClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
      .builder()
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        clusterAvailabilityStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterAvailabilityStatus)
      .optionallyWith(
        clusterCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterCreateTime)
      .optionallyWith(
        clusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterIdentifier)
      .optionallyWith(
        clusterNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterNodes)
      .optionallyWith(
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterGroups)
      .optionallyWith(
        clusterPublicKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterPublicKey)
      .optionallyWith(
        clusterRevisionNumber.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterRevisionNumber)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        clusterSnapshotCopyStatus.map(value => value.buildAwsValue())
      )(_.clusterSnapshotCopyStatus)
      .optionallyWith(
        clusterStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterStatus)
      .optionallyWith(
        clusterSubnetGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterSubnetGroupName)
      .optionallyWith(
        clusterVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterVersion)
      .optionallyWith(
        dbName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dbName)
      .optionallyWith(
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deferredMaintenanceWindows)
      .optionallyWith(elasticIpStatus.map(value => value.buildAwsValue()))(
        _.elasticIpStatus
      )
      .optionallyWith(
        elasticResizeNumberOfNodeOptions.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.elasticResizeNumberOfNodeOptions)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        expectedNextSnapshotScheduleTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expectedNextSnapshotScheduleTime)
      .optionallyWith(
        expectedNextSnapshotScheduleTimeStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expectedNextSnapshotScheduleTimeStatus)
      .optionallyWith(hsmStatus.map(value => value.buildAwsValue()))(
        _.hsmStatus
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        maintenanceTrackName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.maintenanceTrackName)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        nextMaintenanceWindowStartTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.nextMaintenanceWindowStartTime)
      .optionallyWith(
        nodeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nodeType)
      .optionallyWith(
        numberOfNodes.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.numberOfNodes)
      .optionallyWith(
        pendingActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pendingActions)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(resizeInfo.map(value => value.buildAwsValue()))(
        _.resizeInfo
      )
      .optionallyWith(restoreStatus.map(value => value.buildAwsValue()))(
        _.restoreStatus
      )
      .optionallyWith(
        snapshotScheduleIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(
        snapshotScheduleState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotScheduleState)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterDetails.wrap(buildAwsValue())
}
object AwsRedshiftClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterDetails =
      zio.aws.securityhub.model.AwsRedshiftClusterDetails(
        allowVersionUpgrade.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        availabilityZone.map(value => value),
        clusterAvailabilityStatus.map(value => value),
        clusterCreateTime.map(value => value),
        clusterIdentifier.map(value => value),
        clusterNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterPublicKey.map(value => value),
        clusterRevisionNumber.map(value => value),
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterSnapshotCopyStatus.map(value => value.asEditable),
        clusterStatus.map(value => value),
        clusterSubnetGroupName.map(value => value),
        clusterVersion.map(value => value),
        dbName.map(value => value),
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticIpStatus.map(value => value.asEditable),
        elasticResizeNumberOfNodeOptions.map(value => value),
        encrypted.map(value => value),
        endpoint.map(value => value.asEditable),
        enhancedVpcRouting.map(value => value),
        expectedNextSnapshotScheduleTime.map(value => value),
        expectedNextSnapshotScheduleTimeStatus.map(value => value),
        hsmStatus.map(value => value.asEditable),
        iamRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        maintenanceTrackName.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        masterUsername.map(value => value),
        nextMaintenanceWindowStartTime.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        pendingActions.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        resizeInfo.map(value => value.asEditable),
        restoreStatus.map(value => value.asEditable),
        snapshotScheduleIdentifier.map(value => value),
        snapshotScheduleState.map(value => value),
        vpcId.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allowVersionUpgrade: Option[Boolean]
    def automatedSnapshotRetentionPeriod: Option[Integer]
    def availabilityZone: Option[NonEmptyString]
    def clusterAvailabilityStatus: Option[NonEmptyString]
    def clusterCreateTime: Option[NonEmptyString]
    def clusterIdentifier: Option[NonEmptyString]
    def clusterNodes: Option[
      List[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly]
    ]
    def clusterParameterGroups: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly
    ]]
    def clusterPublicKey: Option[NonEmptyString]
    def clusterRevisionNumber: Option[NonEmptyString]
    def clusterSecurityGroups: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly
    ]]
    def clusterSnapshotCopyStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly
    ]
    def clusterStatus: Option[NonEmptyString]
    def clusterSubnetGroupName: Option[NonEmptyString]
    def clusterVersion: Option[NonEmptyString]
    def dbName: Option[NonEmptyString]
    def deferredMaintenanceWindows: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly
    ]]
    def elasticIpStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly
    ]
    def elasticResizeNumberOfNodeOptions: Option[NonEmptyString]
    def encrypted: Option[Boolean]
    def endpoint
        : Option[zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly]
    def enhancedVpcRouting: Option[Boolean]
    def expectedNextSnapshotScheduleTime: Option[NonEmptyString]
    def expectedNextSnapshotScheduleTimeStatus: Option[NonEmptyString]
    def hsmStatus
        : Option[zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly]
    def iamRoles: Option[
      List[zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly]
    ]
    def kmsKeyId: Option[NonEmptyString]
    def maintenanceTrackName: Option[NonEmptyString]
    def manualSnapshotRetentionPeriod: Option[Integer]
    def masterUsername: Option[NonEmptyString]
    def nextMaintenanceWindowStartTime: Option[NonEmptyString]
    def nodeType: Option[NonEmptyString]
    def numberOfNodes: Option[Integer]
    def pendingActions: Option[List[NonEmptyString]]
    def pendingModifiedValues: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly
    ]
    def preferredMaintenanceWindow: Option[NonEmptyString]
    def publiclyAccessible: Option[Boolean]
    def resizeInfo: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly
    ]
    def restoreStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly
    ]
    def snapshotScheduleIdentifier: Option[NonEmptyString]
    def snapshotScheduleState: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def vpcSecurityGroups: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly
    ]]
    def getAllowVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getAutomatedSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "automatedSnapshotRetentionPeriod",
        automatedSnapshotRetentionPeriod
      )
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getClusterAvailabilityStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "clusterAvailabilityStatus",
        clusterAvailabilityStatus
      )
    def getClusterCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getClusterNodes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterNodes", clusterNodes)
    def getClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterGroups",
      clusterParameterGroups
    )
    def getClusterPublicKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterPublicKey", clusterPublicKey)
    def getClusterRevisionNumber: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterRevisionNumber", clusterRevisionNumber)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getClusterSnapshotCopyStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clusterSnapshotCopyStatus",
      clusterSnapshotCopyStatus
    )
    def getClusterStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getClusterSubnetGroupName: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getClusterVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getDbName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDeferredMaintenanceWindows: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deferredMaintenanceWindows",
      deferredMaintenanceWindows
    )
    def getElasticIpStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly
    ] = AwsError.unwrapOptionField("elasticIpStatus", elasticIpStatus)
    def getElasticResizeNumberOfNodeOptions
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "elasticResizeNumberOfNodeOptions",
      elasticResizeNumberOfNodeOptions
    )
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getExpectedNextSnapshotScheduleTime
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "expectedNextSnapshotScheduleTime",
      expectedNextSnapshotScheduleTime
    )
    def getExpectedNextSnapshotScheduleTimeStatus
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "expectedNextSnapshotScheduleTimeStatus",
      expectedNextSnapshotScheduleTimeStatus
    )
    def getHsmStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly
    ] = AwsError.unwrapOptionField("hsmStatus", hsmStatus)
    def getIamRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly
    ]] = AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getMaintenanceTrackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getNextMaintenanceWindowStartTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "nextMaintenanceWindowStartTime",
        nextMaintenanceWindowStartTime
      )
    def getNodeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPendingActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("pendingActions", pendingActions)
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getResizeInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly
    ] = AwsError.unwrapOptionField("resizeInfo", resizeInfo)
    def getRestoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("restoreStatus", restoreStatus)
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getSnapshotScheduleState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotScheduleState", snapshotScheduleState)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly {
    override val allowVersionUpgrade: Option[Boolean] =
      scala.Option(impl.allowVersionUpgrade()).map(value => value: Boolean)
    override val automatedSnapshotRetentionPeriod: Option[Integer] = scala
      .Option(impl.automatedSnapshotRetentionPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val availabilityZone: Option[NonEmptyString] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterAvailabilityStatus: Option[NonEmptyString] = scala
      .Option(impl.clusterAvailabilityStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterCreateTime: Option[NonEmptyString] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterIdentifier: Option[NonEmptyString] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterNodes: Option[
      List[zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly]
    ] = scala
      .Option(impl.clusterNodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.wrap(item)
        }.toList
      )
    override val clusterParameterGroups: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly
    ]] = scala
      .Option(impl.clusterParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup
            .wrap(item)
        }.toList
      )
    override val clusterPublicKey: Option[NonEmptyString] = scala
      .Option(impl.clusterPublicKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterRevisionNumber: Option[NonEmptyString] = scala
      .Option(impl.clusterRevisionNumber())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterSecurityGroups: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly
    ]] = scala
      .Option(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
            .wrap(item)
        }.toList
      )
    override val clusterSnapshotCopyStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.ReadOnly
    ] = scala
      .Option(impl.clusterSnapshotCopyStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus
          .wrap(value)
      )
    override val clusterStatus: Option[NonEmptyString] = scala
      .Option(impl.clusterStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterSubnetGroupName: Option[NonEmptyString] = scala
      .Option(impl.clusterSubnetGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterVersion: Option[NonEmptyString] = scala
      .Option(impl.clusterVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbName: Option[NonEmptyString] = scala
      .Option(impl.dbName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deferredMaintenanceWindows: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly
    ]] = scala
      .Option(impl.deferredMaintenanceWindows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
            .wrap(item)
        }.toList
      )
    override val elasticIpStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly
    ] = scala
      .Option(impl.elasticIpStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.wrap(value)
      )
    override val elasticResizeNumberOfNodeOptions: Option[NonEmptyString] =
      scala
        .Option(impl.elasticResizeNumberOfNodeOptions())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val endpoint: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly
    ] = scala
      .Option(impl.endpoint())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.wrap(value)
      )
    override val enhancedVpcRouting: Option[Boolean] =
      scala.Option(impl.enhancedVpcRouting()).map(value => value: Boolean)
    override val expectedNextSnapshotScheduleTime: Option[NonEmptyString] =
      scala
        .Option(impl.expectedNextSnapshotScheduleTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val expectedNextSnapshotScheduleTimeStatus
        : Option[NonEmptyString] = scala
      .Option(impl.expectedNextSnapshotScheduleTimeStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hsmStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly
    ] = scala
      .Option(impl.hsmStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.wrap(value)
      )
    override val iamRoles: Option[
      List[zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly]
    ] = scala
      .Option(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterIamRole.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val maintenanceTrackName: Option[NonEmptyString] = scala
      .Option(impl.maintenanceTrackName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val manualSnapshotRetentionPeriod: Option[Integer] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val masterUsername: Option[NonEmptyString] = scala
      .Option(impl.masterUsername())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nextMaintenanceWindowStartTime: Option[NonEmptyString] = scala
      .Option(impl.nextMaintenanceWindowStartTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nodeType: Option[NonEmptyString] = scala
      .Option(impl.nodeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val numberOfNodes: Option[Integer] = scala
      .Option(impl.numberOfNodes())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val pendingActions: Option[List[NonEmptyString]] = scala
      .Option(impl.pendingActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val pendingModifiedValues: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues
          .wrap(value)
      )
    override val preferredMaintenanceWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val resizeInfo: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly
    ] = scala
      .Option(impl.resizeInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.wrap(value)
      )
    override val restoreStatus: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.ReadOnly
    ] = scala
      .Option(impl.restoreStatus())
      .map(value =>
        zio.aws.securityhub.model.AwsRedshiftClusterRestoreStatus.wrap(value)
      )
    override val snapshotScheduleIdentifier: Option[NonEmptyString] = scala
      .Option(impl.snapshotScheduleIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snapshotScheduleState: Option[NonEmptyString] = scala
      .Option(impl.snapshotScheduleState())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcSecurityGroups: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly
    ]] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDetails
  ): zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly = new Wrapper(
    impl
  )
}
