package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterParameterGroup(
    clusterParameterStatusList: Option[Iterable[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus
    ]] = None,
    parameterApplyStatus: Option[NonEmptyString] = None,
    parameterGroupName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup = {
    import AwsRedshiftClusterClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
      .builder()
      .optionallyWith(
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterStatusList)
      .optionallyWith(
        parameterApplyStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyStatus)
      .optionallyWith(
        parameterGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup(
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterApplyStatus.map(value => value),
        parameterGroupName.map(value => value)
      )
    def clusterParameterStatusList: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly
    ]]
    def parameterApplyStatus: Option[NonEmptyString]
    def parameterGroupName: Option[NonEmptyString]
    def getClusterParameterStatusList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterStatusList",
      clusterParameterStatusList
    )
    def getParameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getParameterGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly {
    override val clusterParameterStatusList: Option[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly
    ]] = scala
      .Option(impl.clusterParameterStatusList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus
            .wrap(item)
        }.toList
      )
    override val parameterApplyStatus: Option[NonEmptyString] = scala
      .Option(impl.parameterApplyStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val parameterGroupName: Option[NonEmptyString] = scala
      .Option(impl.parameterGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly =
    new Wrapper(impl)
}
